IF OBJECT_ID('RC_CLI_CONV_PBM_CONTROLE_EST_PROD_FECHA_MENSAL') IS NULL
begin
CREATE TABLE [dbo].[RC_CLI_CONV_PBM_CONTROLE_EST_PROD_FECHA_MENSAL](
	[CD_EMP] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL,
	[CD_PROD] [int] NOT NULL,
	[ANO] [int] NOT NULL,
	[MES] [int] NOT NULL,
	[QT_SALDO] [money] NOT NULL,
	[DT_CAD] [datetime] NOT NULL,
 CONSTRAINT [PK_RC_CLI_CONV_PBM_CONTROLE_EST_PROD_FECHA_MENSAL] PRIMARY KEY CLUSTERED 
(
	[CD_EMP] ASC,
	[CD_FILIAL] ASC,
	[CD_PROD] ASC,
	[ANO] ASC,
	[MES] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[RC_CLI_CONV_PBM_CONTROLE_EST_PROD_FECHA_MENSAL] ADD  CONSTRAINT [DF_RC_CLI_CONV_PBM_CONTROLE_EST_PROD_FECHA_MENSAL_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[RC_CLI_CONV_PBM_CONTROLE_EST_PROD_FECHA_MENSAL] ADD  CONSTRAINT [DF_RC_CLI_CONV_PBM_CONTROLE_EST_PROD_FECHA_MENSAL_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]

ALTER TABLE [dbo].[RC_CLI_CONV_PBM_CONTROLE_EST_PROD_FECHA_MENSAL] ADD  CONSTRAINT [DF_RC_CLI_CONV_PBM_CONTROLE_EST_PROD_FECHA_MENSAL_CD_PROD]  DEFAULT ((0)) FOR [CD_PROD]

ALTER TABLE [dbo].[RC_CLI_CONV_PBM_CONTROLE_EST_PROD_FECHA_MENSAL] ADD  CONSTRAINT [DF_RC_CLI_CONV_PBM_CONTROLE_EST_PROD_FECHA_MENSAL_ANO]  DEFAULT ((0)) FOR [ANO]

ALTER TABLE [dbo].[RC_CLI_CONV_PBM_CONTROLE_EST_PROD_FECHA_MENSAL] ADD  CONSTRAINT [DF_RC_CLI_CONV_PBM_CONTROLE_EST_PROD_FECHA_MENSAL_MES]  DEFAULT ((0)) FOR [MES]

ALTER TABLE [dbo].[RC_CLI_CONV_PBM_CONTROLE_EST_PROD_FECHA_MENSAL] ADD  CONSTRAINT [DF_RC_CLI_CONV_PBM_CONTROLE_EST_PROD_FECHA_MENSAL_QT_SALDO]  DEFAULT ((0)) FOR [QT_SALDO]

ALTER TABLE [dbo].[RC_CLI_CONV_PBM_CONTROLE_EST_PROD_FECHA_MENSAL] ADD  CONSTRAINT [DF_RC_CLI_CONV_PBM_CONTROLE_EST_PROD_FECHA_MENSAL_DT_CAD]  DEFAULT (getdate()) FOR [DT_CAD]

ALTER TABLE [dbo].[RC_CLI_CONV_PBM_CONTROLE_EST_PROD_FECHA_MENSAL]  WITH CHECK ADD  CONSTRAINT [FK_RC_CLI_CONV_PBM_CONTROLE_EST_PROD_FECHA_MENSAL_RC_CLI_CONV_PBM_CONTROLE_EST_PROD] FOREIGN KEY([CD_EMP], [CD_FILIAL], [CD_PROD])
REFERENCES [dbo].[RC_CLI_CONV_PBM_CONTROLE_EST_PROD] ([CD_EMP], [CD_FILIAL], [CD_PROD])

ALTER TABLE [dbo].[RC_CLI_CONV_PBM_CONTROLE_EST_PROD_FECHA_MENSAL] CHECK CONSTRAINT [FK_RC_CLI_CONV_PBM_CONTROLE_EST_PROD_FECHA_MENSAL_RC_CLI_CONV_PBM_CONTROLE_EST_PROD]
end